#include "Bullet.h"
#include <DxLib.h>

void shootBullet(Bullet * bullet, int x, int y)
{
	//܂󂢂ĂShell邩
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		if (bullet->shells[i].used == 0) {
			Shell * s = &bullet->shells[i];
			s->used = 1;
			s->x = x;
			s->y = y;
			s->mx = bullet->speed;
			s->my = 0;
			break;
		}
	}
}

void shootBullet(Bullet * bullet, int x, int y, int mx, int my)
{
	//܂󂢂ĂShell邩
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		if (bullet->shells[i].used == 0) {
			Shell * s = &bullet->shells[i];
			
			s->used = 1;
			s->x = x;
			s->y = y;
			s->mx = mx;
			s->my = my;
			break;
		}
	}
}

void drawBullet(Bullet * bullet)
{
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		if (bullet->shells[i].used) {
			DrawRotaGraph(bullet->shells[i].x, bullet->shells[i].y, 1.0, 0, bullet->image, true);
		}
	}
}

void updateBullet(Bullet * bullet)
{
	const int margin = 100;
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		if (bullet->shells[i].used) {
			//ړ
			bullet->shells[i].x += bullet->shells[i].mx;
			bullet->shells[i].y += bullet->shells[i].my;
			if (bullet->shells[i].x < -margin || bullet->shells[i].x > 1920 + margin || bullet->shells[i].y < -margin || bullet->shells[i].y > 1080 + margin) bullet->shells[i].used = false;
		}
	}
}

void clearBullet(Bullet * bullet)
{
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		bullet->shells[i].used = 0;
	}
}



