#include "Enemy.h"
#include <DxLib.h>
#include <math.h>
#include "Player.h"
#include "utility.h"


void clearMobs(Mobs * mobs)
{
	for (int i = 0; i < MAX_ENEMY_NUM; i++) {
		mobs->enemys[i].used = 0;
		mobs->enemys[i].health = -1;
		clearBullet(&mobs->enemys[i].bullet);
	}
	mobs->apps_idx = 0;
	mobs->root_count = 0;
	
}

void updateMobs(Mobs * mobs, int target_x, int target_y, int is_shoot)
{
	mobs->root_count++;

	//蔻āAhealth0ɂȂ̂ƓcountZbgB

	//o
	//:appscountlŃ\[gĂKvB
	for (; mobs->apps_idx >= 0 && mobs->apps_idx < mobs->max_enemies; mobs->apps_idx++) {
		if (mobs->apps[mobs->apps_idx].count <= mobs->root_count) {
			//o
			for (int i = 0; i < MAX_ENEMY_NUM; i++) {
				if (mobs->enemys[i].used == 0) {
					//̃󂢂Ă܂
					mobs->enemys[i] = *mobs->apps[mobs->apps_idx].enemy;	//Go
					mobs->enemys[i].x = mobs->apps[mobs->apps_idx].x;
					mobs->enemys[i].y = mobs->apps[mobs->apps_idx].y;
					mobs->enemys[i].used = 1;
					mobs->enemys[i].count = mobs->enemys[i].movements[0].count;
					break;
				}
			}
		}
		else break;
	}

	//ړ
	const int margin = 500;
	for (int i = 0; i < MAX_ENEMY_NUM; i++) {
		Enemy * p = &mobs->enemys[i];
		if (p->health > 0) {
			//ړ
			while (p->count <= 0) {
				if (++p->movement_idx >= p->movement_num) p->movement_idx = 1;
				p->count = p->movements[p->movement_idx].count;
			}

			p->x += p->movements[p->movement_idx].move_x;
			p->y += p->movements[p->movement_idx].move_y;

			if (p->x < (-margin - p->w) || p->x > (1920+margin + p->w) || p->y < (-margin - p->h) || p->y > (1080+margin + p->h)) p->health = -10;


		}
		if(p->used) p->count--;
	}

	//U
	for (int i = 0; i < MAX_ENEMY_NUM; i++) {
		Enemy * p = &mobs->enemys[i];
		if (p->used) {
			//
			if (p->attack_count <= 0 && p->health > 0 && is_shoot) {
				double dx = target_x - (p->canons[p->canon_idx].x + p->x);
				double dy = target_y - (p->canons[p->canon_idx].y + p->y);

				double ex = p->bullet.speed / sqrt(dx * dx + dy * dy);

				
				shootBullet(&p->bullet, p->canons[p->canon_idx].x + p->x, p->canons[p->canon_idx].y + p->y, dx * ex, dy * ex);

				if (++p->canon_idx >= p->canon_num) p->canon_idx = 0;
				p->attack_count = p->attack_interval;
			}
			updateBullet(&p->bullet);
			p->attack_count--;

			//H
			int n = 0;
			if (p->count <= 0 && p->health == 0) p->health = -10;	//GtFNgI
			for (; n < SHELL_MAXNUM && p->health <= -10; n++) {
				if (p->bullet.shells[n].used) break;
			}
			if (n == SHELL_MAXNUM) p->used = 0;

		}
	}


	
}

void drawMobs(Mobs * mobs, const Resource * resource)
{
	for (int i = 0; i < MAX_ENEMY_NUM; i++) {
		if (mobs->enemys[i].used) {


			if (mobs->enemys[i].health > 0) {
				//ʏɕ`
				DrawRotaGraph(mobs->enemys[i].x, mobs->enemys[i].y, 1.0, 0, mobs->enemys[i].image, true); 
				DrawBox(mobs->enemys[i].x - 25, mobs->enemys[i].y - mobs->enemys[i].h / 2, mobs->enemys[i].x + 25, mobs->enemys[i].y - mobs->enemys[i].h / 2 + 2, GetColor(100, 100, 100), true);
				DrawBox(mobs->enemys[i].x - 25, mobs->enemys[i].y - mobs->enemys[i].h / 2, mobs->enemys[i].x - 25 + (mobs->enemys[i].health) * 50 / mobs->enemys[i].full_health, mobs->enemys[i].y - mobs->enemys[i].h / 2 + 2, GetColor(255, 20, 20), true);

			}
			else if(mobs->enemys[i].health == 0){
				//GtFNg
				//DrawRotaGraph(mobs->enemys[i].x, mobs->enemys[i].y, 1.0, 0, mobs->enemys[i].image, true);
				if (mobs->enemys[i].count > 0) DrawRotaGraph(mobs->enemys[i].x, mobs->enemys[i].y, 1.0 + 0.0002 * mobs->enemys[i].h * (20 - mobs->enemys[i].count), 0, resource->explosion_image, true);
			}
			//DrawFormatString(mobs->enemys[i].x, mobs->enemys[i].y - mobs->enemys[i].h / 2, GetColor(255, 255, 255), "HP:%d", mobs->enemys[i].health);
	

			drawBullet(&mobs->enemys[i].bullet);
		}
	}
}

void setMovement(Movement * mv, int idx, int mx, int my, int count)
{
	mv[idx].count = count;
	mv[idx].move_x = mx;
	mv[idx].move_y = my;
}

void setAppearance(Appearance * apps, int idx, Enemy * enemy, int x, int y, int count)
{
	apps[idx].count = count;
	apps[idx].enemy = enemy;
	apps[idx].x = x;
	apps[idx].y = y;

}

int checkHit_MtoB(Mobs * mb, Bullet * bt, const Resource * rs)
{
	int is_hit = 0;
	for (int i = 0; i < SHELL_MAXNUM; i++) {
		for (int n = 0; n < MAX_ENEMY_NUM && bt->shells[i].used; n++) {
			Enemy * en = &mb->enemys[n];
			if (en->health > 0) {
				Shell * p = &bt->shells[i];
				if (checkHit(en->x, en->y, en->w, en->h, p->x, p->y, bt->w, bt->h)) {
					//qbg
					en->health -= bt->damage;
					if (en->health <= 0) {
						//GS
						en->count = 20;
						en->health = 0;
						PlaySoundMem(rs->explosion_sound, DX_PLAYTYPE_BACK);
						//PlaySoundMem(explosion_sound, DX_PLAYTYPE_BACK);
						is_hit |= 2;
					}
					else {

						PlaySoundMem(rs->damage_sound2, DX_PLAYTYPE_BACK);
					}
					p->used = 0;
					is_hit |= 1;
				}
			}
		}
	}
	return is_hit;
}

