#pragma once
#ifndef _ENEMY_H_INCLUDED
#define _ENEMY_H_INCLUDED

#include "Bullet.h"
#include "Resource.h"

#define MAX_ENEMY_NUM 128

struct {
	int move_x = 0, move_y = 0, count = 0;

}typedef Movement;

struct {
	int x;
	int y;
}typedef Canon;

struct {
	int x = 0, y = 0;
	int health = -1;
	int full_health = 100;
	int used = 0;
	int count = 0;
	int image = 0;
	int w = 0, h = 0;

	int attack_interval = 100;
	int attack_count = 0;

	Movement movements[8];	//[v[1]`[movement_num-1]܂
	int movement_num = 0;
	int movement_idx = 0;

	Canon canons[16];
	int canon_num = 0;
	int canon_idx = 0;

	Bullet bullet;
}typedef Enemy;


struct {
	Enemy * enemy = 0;
	int count = 0;
	int x, y;
}typedef Appearance;

struct {

	Appearance apps[MAX_ENEMY_NUM];
	Enemy enemys[MAX_ENEMY_NUM];
	int max_enemies = 0;
	int root_count = 0;
	int apps_idx = 0;

}typedef Mobs;

extern void clearMobs(Mobs * mobs);

extern void updateMobs(Mobs * mobs, int target_x, int target_y, int is_shoot = 1);
extern void drawMobs(Mobs * mobs, const Resource * resource);

extern void setMovement(Movement * mv, int idx, int mx, int my, int count);
extern void setAppearance(Appearance * apps, int idx, Enemy * enemy, int x, int y, int count);

extern int checkHit_MtoB(Mobs * mb, Bullet * bt, const Resource * rs);

#endif