
#include "Scene.h"
#include <DxLib.h>
#include "Bullet.h"
#include "Enemy.h"
#include <math.h>

#include "UI.h"
int GameScene(GameInformation * gi) {
	int next_scene = SCENE_GAME;

	//œǂݍ
	if (gi == NULL) return SCENE_SHUTDONW;
	

	
	gi->count_timer = 0;

	while (ProcessMessage() == 0 && next_scene == SCENE_GAME) {
		ClearDrawScreen();
		clsDx();

		//wi̕\
		DrawGraph(0, 0, gi->rs.background, false);

		updatePlayer(&gi->player);

		//G̏oAړ
		updateMobs(&gi->mobs, gi->player.x, gi->player.y);


		//蔻
		if (checkHit_Player(&gi->player, &gi->mobs)) {
			if (gi->player.health <= 0) {
				PlaySoundMem(gi->rs.explosion_sound, DX_PLAYTYPE_BACK);
				next_scene = SCENE_RESULT;
				gi->is_clear = 0;
				gi->screen_move_count = 20;
			}
			else {
				PlaySoundMem(gi->rs.damage_sound, DX_PLAYTYPE_BACK);
				gi->screen_move_count = 5;
			}
		}
		
		
		if (checkHit_MtoB(&gi->mobs, &gi->player.bullet, &gi->rs) & 0x02) {
			gi->screen_move_count = 10;
		}


		//@̕\
		drawPlayer(&gi->player, &gi->rs);

		//G̕\
		drawMobs(&gi->mobs, &gi->rs);

		//e̕\
		drawBullet(&gi->player.bullet);


		if ((double)gi->player.health / gi->player.full_health < 0.4) {
			if ((double)gi->player.health / gi->player.full_health < 0.2) {
				if (!CheckSoundMem(gi->rs.danger_sound2)) {
					StopSoundMem(gi->rs.danger_sound1);
					PlaySoundMem(gi->rs.danger_sound2, DX_PLAYTYPE_LOOP);
					gi->count_timer = 0;
				}
			}
			else if (!CheckSoundMem(gi->rs.danger_sound1)) {
				PlaySoundMem(gi->rs.danger_sound1, DX_PLAYTYPE_LOOP);
				gi->count_timer = 0;
			}
		}

		//UI̕\
		drawUI(gi);


		//V[J

		//NA
		if(gi->mobs.apps_idx == gi->mobs.max_enemies) {
			int is_clear = 1;
			for (int i = 0; i < MAX_ENEMY_NUM && is_clear; i++) {
				if (gi->mobs.enemys[i].used) is_clear = 0;
			}
			if (is_clear) {
				next_scene = SCENE_RESULT;
				gi->is_clear = 1;
			}
		}


		if (CheckHitKey(KEY_INPUT_ESCAPE)) next_scene = SCENE_SHUTDONW;
		
		gi->count_timer++;
		ScreenFlip2(gi);
	}

	//x񉹂
	StopSoundMem(gi->rs.danger_sound1);
	StopSoundMem(gi->rs.danger_sound2);
	return next_scene;
}

int GameResultScene(GameInformation * gi)
{
	
	int next_scene = SCENE_RESULT;

	//œǂݍ
	if (gi == NULL) return SCENE_SHUTDONW;


	int count = 0;
	StopSoundMem(gi->rs.bgm);
	if (gi->is_clear) PlaySoundMem(gi->rs.gameclear_sound, DX_PLAYTYPE_BACK);
	else PlaySoundMem(gi->rs.gameover_sound, DX_PLAYTYPE_BACK);

	while (ProcessMessage() == 0 && next_scene == SCENE_RESULT) {
		ClearDrawScreen();
		clsDx();

		//wi̕\
		DrawGraph(0, 0, gi->rs.background, false);
		
		//G̏oAړ
		updateMobs(&gi->mobs, gi->player.x, gi->player.y, 0);

		updatePlayer(&gi->player);
		//@̕\
		drawPlayer(&gi->player, &gi->rs);

		//G̕\
		drawMobs(&gi->mobs, &gi->rs);

		//e̕\
		drawBullet(&gi->player.bullet);

		//UI̕\
		drawUI(gi);

		if (gi->is_clear) DrawGraph(87,366, gi->rs.gameclear, true);	//87,366
		else DrawGraph(212, 361, gi->rs.gameover, true);	//87,366

		//V[J
		if (CheckHitKey(KEY_INPUT_ESCAPE)) next_scene = SCENE_SHUTDONW;
		if (count > 300) next_scene = SCENE_TITLE;
		
		count++;
		gi->count_timer++;

		ScreenFlip2(gi);
	}


	return next_scene;

}

void ScreenFlip2(GameInformation * gi)
{
	SetDrawScreen(DX_SCREEN_BACK);
	ClearDrawScreen();
	//h炷
	if (gi->screen_move_count < 0) {
		(++gi->screen_move_count) *= -1;
	}else if (gi->screen_move_count > 0) {
		(--gi->screen_move_count) *= -1;
	}
	DrawGraph(gi->screen_move_count, 0, gi->screen, false);
	
	const int ave = 30;
	if (++gi->fps_ave >= ave) {
		gi->fps = (double)(GetNowCount() - gi->fps_count) / ave;
		gi->fps = 1000.0 / gi->fps;
		gi->fps_count = GetNowCount();
		gi->fps_ave = 0;
	}
	DrawFormatString(0,0,GetColor(255,255,255),"FPS:%.2f",gi->fps);
	ScreenFlip();
	SetDrawScreen(gi->screen);
}
