#include "Player.h"
#include <DxLib.h>
#include "utility.h"


void damagePlayer(Player * player, int damage) {
	player->health -= damage;
	player->matchless_time = player->matchless_interval;
	if (player->health <= 0) {
		//S
		player->health = 0;
		player->bullet_count = 20;
	}
	player->disp_health_delta = 0;
}


int checkHit_PtoM(Player * player, Mobs * mb)
{
	int is_hit = 0;
	for (int i = 0; i < MAX_ENEMY_NUM && player->matchless_time == 0; i++) {
		if (mb->enemys[i].health > 0) {
			Enemy * p = &mb->enemys[i];
			if (checkHit(player->x, player->y, player->w, player->h, p->x, p->y, p->w, p->h)) {
				//qbg
				damagePlayer(player, p->health);
				is_hit = 1;
			}
		}
	}
	return is_hit;
}

int checkHit_Player(Player * player, Mobs * mb)
{
	int is_hit = 0;

	if (player->health > 0) {
		is_hit = checkHit_PtoM(player, mb);

		for (int i = 0; i < MAX_ENEMY_NUM && player->matchless_time == 0 && player->health > 0; i++) {
			is_hit = checkHit_PtoB(player, &mb->enemys[i].bullet);
		}
	}

	return is_hit;
}

int checkHit_PtoB(Player * player, Bullet * bt)
{
	int is_hit = 0;
	for (int i = 0; i < SHELL_MAXNUM && player->matchless_time == 0; i++) {
		if (bt->shells[i].used == 1) {
			Shell * p = &bt->shells[i];
			if (checkHit(player->x, player->y, player->w, player->h, p->x, p->y, bt->w, bt->h)) {
				//qbg
				damagePlayer(player, bt->damage);
				p->used = 0;
				is_hit = 1;
			}
		}
	}
	return is_hit;
}

void updatePlayer(Player * player)
{

	if (player->health > 0) {

		//@̈ړ
		if (CheckHitKey(KEY_INPUT_UP)) player->y -= player->speed;
		if (CheckHitKey(KEY_INPUT_LEFT)) player->x -= player->speed;
		if (CheckHitKey(KEY_INPUT_DOWN)) player->y += player->speed;
		if (CheckHitKey(KEY_INPUT_RIGHT)) player->x += player->speed;
		if (player->x < player->w / 2) player->x = player->w / 2;
		if (player->x > 1920 - player->w / 2) player->x = 1920 - player->w / 2;
		if (player->y < player->h / 2) player->y = player->h / 2;
		if (player->y > 1080 - player->h / 2) player->y = 1080 - player->h / 2;


		//e̔

		if (CheckHitKey(KEY_INPUT_SPACE) && player->bullet_count <= 0) {
			player->bullet_count = player->bullet.interval;	//e̔ˊԊu5
			shootBullet(&player->bullet, player->x + 74, player->y + -5);
		}

	}

	if (player->bullet_count > 0) player->bullet_count--;


	updateBullet(&player->bullet);


	if (player->matchless_time > 0) player->matchless_time--;
}

void drawPlayer(Player * player, const Resource * rs)
{
	//@̕\
	if(player->matchless_time / 2 % 2 == 0 && player->health > 0)	DrawRotaGraph(player->x, player->y, 1.0, 0, player->image, true);
	if (player->health <= 0) {
		//GtFNg
		if (player->bullet_count > 0) DrawRotaGraph(player->x, player->y, 1.0 + 0.0002 * player->h * (20 - player->bullet_count), 0, rs->explosion_image, true);
	}

	//HP̕\vZ
	const double division = 15.0;
	if (player->health != player->disp_health) {
		if (player->disp_health_delta == 0) {
			player->disp_health_delta = (player->disp_health - player->health);
			if (abs(player->disp_health_delta) < division) player->disp_health_delta = player->disp_health_delta / abs(player->disp_health_delta);
			else player->disp_health_delta /= division;
		}

		player->disp_health -= player->disp_health_delta;
		if ((player->disp_health_delta < 0 && player->disp_health > player->health) || (player->disp_health_delta > 0 && player->disp_health < player->health)) {
			player->disp_health = player->health;
			player->disp_health_delta = 0;
		}
	}
	else player->disp_health = player->health;
}
