#include "Scene.h"
#include <DxLib.h>

int TitleScene(GameInformation * gi){
	
	int next_scene = 0;

	//
	int title_image = LoadGraph("media\\title.jpg");

	if(!CheckSoundMem(gi->rs.bgm)) PlaySoundMem(gi->rs.bgm, DX_PLAYTYPE_LOOP);

	while (ProcessMessage() == 0 && next_scene == 0) {
		ClearDrawScreen();

		DrawGraph(0, 0, title_image, false);

		if (CheckHitKey(KEY_INPUT_RETURN)) {
			next_scene = SCENE_PREPARE_GAME;
			PlaySoundMem(gi->rs.decision, DX_PLAYTYPE_BACK);
		}
		if (CheckHitKey(KEY_INPUT_ESCAPE)) next_scene = SCENE_SHUTDONW;
		
		ScreenFlip2(gi);
	}

	DeleteGraph(title_image);


	return next_scene;

}